/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.activity;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.servlet.activity.ActivityManager;
import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.PmDataBean;
import com.ibm.hwmca.fw.servlet.pmod.event.ModelActionEvent;
import com.ibm.hwmca.fw.servlet.pmod.event.ModelActionListener;
import com.ibm.hwmca.fw.task.PresentationTask;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;

public class ReauthenticationTask
extends PresentationTask
implements PmDataBean,
ModelActionListener {
    private static final String TRACE_MASKT = "XTIFREAT";
    private static final String TRACE_MASKF = "XTIFREAF";
    public static final int AUTHENTICATION_NO_RESULT = 0;
    public static final int AUTHENTICATION_SUCCESSFUL = 1;
    public static final int AUTHENTICATION_FAILED = 2;
    private static final String RESOURCE_BUNDLE = "com.ibm.hwmca.fw.servlet.activity.res.reauthentication";
    public static final short RUN_ERROR = 2356;
    private int result;
    private int incorrectPasswords;
    private boolean taskCompleted;
    protected PanelModel mainPanelModel;
    protected String password = "";

    public ReauthenticationTask(PresentationTaskParms parms) {
        super(parms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runTask() throws Exception {
        Object var1_1;
        try {
            ActivityManager.getActivityManager().reauthenticationStarted(this.getHMCSession(), this);
            this.showMainPanel();
            var1_1 = null;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Trace.trace(TRACE_MASKT, "Reauthentication yielded " + this.getReauthResult());
            ActivityManager.getActivityManager().reauthenticationFinished(this.getHMCSession(), this.result);
            throw throwable;
        }
        Trace.trace(TRACE_MASKT, "Reauthentication yielded " + this.getReauthResult());
        ActivityManager.getActivityManager().reauthenticationFinished(this.getHMCSession(), this.result);
        return var1_1;
    }

    protected void showMainPanel() {
        this.mainPanelModel = new PanelModel("com.ibm.hwmca.fw.servlet.activity.res.reauthmain", RESOURCE_BUNDLE, this, this.getHMCSession().getUserContext().getLocales());
        this.mainPanelModel.addModelActionListener(this);
        this.mainPanelModel.render();
        this.waitForTaskToFinish();
    }

    public void logException(Throwable throwable) {
        FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "ReAuthTask");
        new FrameworkLog(classLogInfo, 2356, throwable).log();
    }

    protected void forceTermination(String reason) {
        this.setCompletionInfo(0);
    }

    protected void processReauthButton() {
        this.mainPanelModel.commitPanelChanges();
        if (this.password == null || this.password.length() == 0) {
            this.showErrorMessage("incorrectInputTitle", "mustEnterPW");
            return;
        }
        if (!User.getUser(this.getHMCSession().getUserContext().getUserName()).isPasswordValid(this.password)) {
            this.showErrorMessage("incorrectInputTitle", "pwIsWrong");
            if (++this.incorrectPasswords >= 3) {
                this.showErrorMessage("incorrectInputTitle", "tooManyAttempts");
                this.setCompletionInfo(2);
            }
            return;
        }
        this.setCompletionInfo(1);
    }

    public void actionPerformed(ModelActionEvent event) {
        String command = event.getActionCommand();
        Trace.trace(TRACE_MASKT, "Processing ReauthenticateTask action command \"" + command + "\".");
        if (command.equals("authenticate")) {
            this.processReauthButton();
        }
    }

    private synchronized void waitForTaskToFinish() {
        Trace.trace(TRACE_MASKT, "ReauthenticateTask waiting for user to close the task.");
        while (!this.taskCompleted) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCompletionInfo(int result) {
        this.result = result;
        this.mainPanelModel.dispose();
        ReauthenticationTask reauthenticationTask = this;
        synchronized (reauthenticationTask) {
            this.taskCompleted = true;
            this.notify();
        }
    }

    protected void showErrorMessage(String titleKey, String messageKey) {
        this.showErrorMessage(titleKey, messageKey, null);
    }

    protected void showErrorMessage(String titleKey, String messageKey, Object[] substitutionData) {
        try {
            LocalizableText[] buttons = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
            LocalizableText title = new LocalizableText(RESOURCE_BUNDLE, titleKey);
            MessageText message = new MessageText(RESOURCE_BUNDLE, messageKey, substitutionData);
            CommonMsgApp.showMessageBox(null, title, message, MsgType.ERROR_MESSAGE, buttons);
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKT, "Ignoring exception rendering error message with key==" + messageKey);
            Trace.trace(TRACE_MASKT, e);
        }
    }

    private String getReauthResult() {
        switch (this.result) {
            case 0: {
                return "no result";
            }
            case 1: {
                return "success";
            }
            case 2: {
                return "failure";
            }
        }
        return "(unknown)";
    }

    public String getUserid() {
        return this.getHMCSession().getUserContext().getUserName();
    }

    public void setPassword(String pw) {
        this.password = pw;
    }

    public String getPassword() {
        return this.password;
    }
}

